//=============================================================================
// Xmas Armor powerup.
//=============================================================================
class XmasArmor extends Armor2;


#exec TEXTURE IMPORT NAME=santassuit FILE=Textures\santassuit.bmp 
#exec AUDIO IMPORT FILE="Sounds\xmasSuit.WAV" NAME="xmasSuit"

function bool HandlePickupQuery( inventory Item )
{
	local inventory S;

	if ( item.class == class ) 
	{
		S = Pawn(Owner).FindInventoryType(class'UT_Shieldbelt');	
		if (  S==None )
		{
			if ( Charge<Item.Charge )	
				Charge = Item.Charge;
		}
		else
			Charge = Clamp(S.Default.Charge - S.Charge, Charge, Item.Charge );
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogPickup(Item, Pawn(Owner));
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogPickup(Item, Pawn(Owner));
		if ( PickupMessageClass == None )
			Pawn(Owner).ClientMessage(PickupMessage, 'Pickup');
		else
			Pawn(Owner).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
		Item.PlaySound (PickupSound,,2.0);
		Item.SetReSpawn();
		return true;				
	}
	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy, S;

	Copy = Super.SpawnCopy(Other);
	S = Other.FindInventoryType(class'UT_Shieldbelt');	
	if ( S != None )
	{
		Copy.Charge = Min(Copy.Charge, S.Default.Charge - S.Charge);
		if ( Copy.Charge <= 0 )
		{ 
			S.Charge -= 1;
			Copy.Charge = 1;
		}
	}
	return Copy;
}

defaultproperties
{
     PickupMessage="You got Santas suit."
     ItemName="Santas suit"
     PickupViewMesh=LodMesh'UnrealShare.Suit'
     ProtectionType1=Burned
     PickupSound=Sound'DanesXmas_v2009.xmasSuit'
     Mesh=LodMesh'UnrealShare.Suit'
     MultiSkins(0)=Texture'DanesXmas_v2009.santassuit'
     MultiSkins(1)=Texture'DanesXmas_v2009.santassuit'
}
